﻿using UnityEngine;

public static class XRInput

{
    // WMR - right hand controller
    private static int BTN_TRIGGER = 15;
    private static int BTN_TOUCHPAD_TOUCH = 19;
    private static int BTN_TOUCHPAD_CLICK = 17;
    private static int AXIS_TOUCHPAD_X = 19;
    private static int AXIS_TOUCHPAD_Y = 20;
       
    // Use those names for Input names
    public static string Trigger = "Button" + BTN_TRIGGER;
    public static string TouchpadTouch = "Button" + BTN_TOUCHPAD_TOUCH;
    public static string TouchpadClick = "Button" + BTN_TOUCHPAD_CLICK;

    public static string TouchpadX = "Axis" + AXIS_TOUCHPAD_X;
    public static string TouchpadY = "Axis" + AXIS_TOUCHPAD_Y;

    public static void SetupAxes(string deviceName)
    {
        Debug.Log("SetupAxes: " + deviceName);
        // See:
        // https://docs.unity3d.com/Manual/xr_input.html
        switch (deviceName)
        {
            case "WindowsMR":
                WindowsMR();
                break;
            case "Oculus":
#if UNITY_ANDROID
                Debug.LogError("Not implemented yet");
                Debug.Break();
#else
                Oculus();
#endif
                break;
            default:
                Debug.LogError("Not implemented yet");
                Debug.Break();
                break;
        }
    }

    private static void Oculus()
    {
        // TODO
    }

    private static void OculusGo()
    {
        BTN_TRIGGER = 15;
        BTN_TOUCHPAD_TOUCH = 17;
        BTN_TOUCHPAD_CLICK = 9;
        AXIS_TOUCHPAD_X = 4;
        AXIS_TOUCHPAD_Y = 5;
        CalculateNames();
    }

    private static void WindowsMR()
    {
        BTN_TRIGGER = 15;
        BTN_TOUCHPAD_TOUCH = 19;
        BTN_TOUCHPAD_CLICK = 17;
        AXIS_TOUCHPAD_X = 19;
        AXIS_TOUCHPAD_Y = 20;
        CalculateNames();
    }

    private static void CalculateNames()
    {
    Trigger = "Button" + BTN_TRIGGER;
    TouchpadTouch = "Button" + BTN_TOUCHPAD_TOUCH;
    TouchpadClick = "Button" + BTN_TOUCHPAD_CLICK;
    TouchpadX = "Axis" + AXIS_TOUCHPAD_X;
    TouchpadY = "Axis" + AXIS_TOUCHPAD_Y;
    }
}

